/**
* \file: levelchanger.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: authorization level daemon
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef ALD_CONTROL_LEVELCHANGER_H
#define ALD_CONTROL_LEVELCHANGER_H

#include <stdbool.h>
#include "ald_types.h"
#include "model/level_configuration.h"

error_code_t levelchanger_init(void);

void levelchanger_deinit(void);

error_code_t levelchanger_prepare_levelchange(security_level_t targeted_level, bool *is_permanent_ptr);

void levelchanger_unprepare_levelchange(void);

error_code_t levelchanger_kickoff_levelchange(change_type_t type);

int levelchanger_get_pollfd(void);

void levelchanger_on_event(void);

pid_t levelchanger_get_script_exec_prc_id(void);

void levelchanger_set_result_to_script_exec_timeout(void);

#endif
